#include <iostream>
#include <vector>

template<typename V, typename P>
static V* my_binary_search(V* begin, unsigned count, const V& value, P pred)
{
	V* it = begin;
	while (count != 1)
	{
		it = begin + count / 2;

		if (pred(*it, value))
		{
			count -= it - begin;
			begin = it;
		}
		else if (!pred(value, *it))
			return it;
		else
			count /= 2;		
	}
	if (pred(value, *begin))
		return begin;
	else
		return begin + 1;
}

struct Frilenser
{
	double A;
	double P;	
};

static inline bool pred(const Frilenser& a, const Frilenser& b) 
{
	return (a.P > b.P); 
}

int main()
{
	int n;
	std::cin >> n;	
			
	std::vector<Frilenser> arr(1);	
	arr.reserve(n);	

	std::cin >> arr[0].A >> arr[0].P;
	arr[0].P /= 100;

	for (int i = 1; i < n; ++i)
	{		
		Frilenser f;
		std::cin >> f.A >> f.P;
		f.P /= 100;
		
		arr.insert(arr.begin() + (my_binary_search(arr.data(), arr.size(), f, pred) - arr.data()), f);		
	}		
	
	double best = 0;
	double buzdet;
	for (int i = 0; i < n; ++i)
	{
		buzdet = 0;
		for (int j = 0; j <= i; ++j)			
			buzdet += arr[j].A * arr[i].P;
		if (buzdet > best)
			best = buzdet;
	}

	printf("%.4f\n", best);		

	return 0;
}